/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.snapshot.delete;

import jakarta.inject.Inject;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.gridgain.internal.cli.call.snapshot.SnapshotDeleteCall;
import org.gridgain.internal.cli.call.snapshot.SnapshotDeleteCallInput;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"Deletes a snapshot"})
public class SnapshotDeleteCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.Option(names={"--id"}, description={"ID of the snapshot"}, required=true)
    private UUID snapshotId;
    @Inject
    private SnapshotDeleteCall call;

    @Override
    public Integer call() {
        return this.runPipeline(CallExecutionPipeline.builder(this.call).inputProvider(this::buildCallInput).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot delete snapshot")));
    }

    private SnapshotDeleteCallInput buildCallInput() {
        return SnapshotDeleteCallInput.builder().clusterUrl(this.clusterUrl.getClusterUrl()).snapshotId(this.snapshotId).build();
    }
}

