/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.role.repl;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.rbac.role.ListRolesCall;
import org.gridgain.internal.cli.call.rbac.role.ListRolesCallInput;
import org.gridgain.internal.cli.decorators.RoleListDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List roles"})
public class RoleListReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--user"}, description={"Filter by user name"})
    private String user;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain = false;
    @Inject
    private ListRolesCall listRolesCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.listRolesCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot list roles")).print(new RoleListDecorator(this.plain)));
    }

    private ListRolesCallInput input(String clusterUrl) {
        return ListRolesCallInput.builder().filterByUsername(this.user).clusterUrl(clusterUrl).build();
    }
}

