/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.role.privilege.repl;

import jakarta.inject.Inject;
import java.util.List;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.rbac.assignments.GrantPrivilegeCall;
import org.gridgain.internal.cli.call.rbac.assignments.GrantRevokePrivilegeCallInput;
import org.gridgain.internal.cli.call.rbac.privilege.Action;
import org.gridgain.internal.cli.core.converters.ActionConverter;
import picocli.CommandLine;

@CommandLine.Command(name="grant", description={"Grant privilege to role"})
public class RolePrivilegeReplGrantCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(names={"--to"}, description={"To role name"}, required=true, split=",")
    private List<String> roleName;
    @CommandLine.Option(names={"--action"}, description={"Action"}, required=true, converter={ActionConverter.class}, split=",")
    private List<Action> action;
    @CommandLine.Option(names={"--on"}, description={"Object"})
    private String object;
    @Inject
    private GrantPrivilegeCall grantPrivilegeCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.grantPrivilegeCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot grant privilege")).print());
    }

    private GrantRevokePrivilegeCallInput input(String clusterUrl) {
        return GrantRevokePrivilegeCallInput.builder().clusterUrl(clusterUrl).roleNames(this.roleName).actions(this.action).object(this.object).build();
    }
}

