/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.role;

import jakarta.inject.Inject;
import java.util.concurrent.Callable;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.gridgain.internal.cli.call.rbac.role.GetRoleCall;
import org.gridgain.internal.cli.call.rbac.role.ShowRoleCallInput;
import org.gridgain.internal.cli.decorators.RoleDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="show", description={"Show role information"})
public class RoleShowCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.Parameters(description={"Role name"})
    private String roleName;
    @CommandLine.Option(names={"--with-users"}, description={"Show role with assigned users"})
    private boolean users;
    @CommandLine.Option(names={"--with-privileges"}, description={"Show role with granted privileges"})
    private boolean privileges;
    @Inject
    private GetRoleCall getRoleCall;

    @Override
    public Integer call() {
        return this.runPipeline(CallExecutionPipeline.builder(this.getRoleCall).inputProvider(() -> ShowRoleCallInput.builder().clusterUrl(this.clusterUrl.getClusterUrl()).roleName(this.roleName).showUsers(this.users).showPrivileges(this.privileges).build()).decorator(new RoleDecorator()).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot show role")));
    }
}

