/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.pitr.tables;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.pitr.TablesRecoveryStartCall;
import org.gridgain.internal.cli.call.pitr.TablesRecoveryStartCallInput;
import org.gridgain.internal.cli.commands.pitr.tables.RecoveryTablesMixin;
import picocli.CommandLine;

@CommandLine.Command(name="start", description={"Starts a table point-in-time recovery"})
class RecoveryTablesStartReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Mixin
    private RecoveryTablesMixin parameters;
    @Inject
    private TablesRecoveryStartCall call;
    @Inject
    private ConnectToClusterQuestion question;

    RecoveryTablesStartReplCommand() {
    }

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::buildCallInput).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot start recovery")).print());
    }

    private TablesRecoveryStartCallInput buildCallInput(String clusterUrl) {
        return this.parameters.toBuilder().clusterUrl(clusterUrl).build();
    }
}

