/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.dcr.repl;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.dcr.DeleteReplicationReplCall;
import org.gridgain.internal.cli.call.dcr.ReplicationNameCallInput;
import org.gridgain.internal.cli.commands.dcr.DcReplicationName;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"Delete data center replication."})
public class DcReplicationDeleteReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.ArgGroup(multiplicity="1")
    private DcReplicationName name;
    @Inject
    private DeleteReplicationReplCall deleteReplicationCall;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.deleteReplicationCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot delete replication")).print());
    }

    private ReplicationNameCallInput input(String url) {
        return ReplicationNameCallInput.builder().replicationName(this.name.replicationName()).clusterUrl(url).build();
    }
}

