/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.dcr;

import jakarta.inject.Inject;
import java.time.Instant;
import java.util.concurrent.Callable;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlProfileMixin;
import org.apache.ignite3.internal.cli.core.call.CallExecutionPipeline;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.gridgain.internal.cli.call.dcr.FlushReplicationCall;
import org.gridgain.internal.cli.call.dcr.FlushReplicationCallInput;
import org.gridgain.internal.cli.commands.dcr.DcReplicationName;
import picocli.CommandLine;

@CommandLine.Command(name="flush", description={"Set replication flush point with provided timestamp."})
public class DcReplicationFlushCommand
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    private ClusterUrlProfileMixin clusterUrl;
    @CommandLine.ArgGroup(multiplicity="1")
    private DcReplicationName name;
    @CommandLine.Option(names={"--flush-point"}, description={"The flush point is a timestamp in the ISO-8601 format that is used to determine whether the replicated data is sufficient. After setting a flush point, replication will be considered completed at the moment when all replicated tables have all received data older than this flush point. Example: 1970-01-01T00:00:00Z."}, required=true)
    private Instant flushPoint;
    @Inject
    private FlushReplicationCall flushReplicationCall;

    @Override
    public Integer call() throws Exception {
        return this.runPipeline(CallExecutionPipeline.builder(this.flushReplicationCall).inputProvider(() -> FlushReplicationCallInput.builder().replicationName(this.name.replicationName()).clusterUrl(this.clusterUrl.getClusterUrl()).flushPoint(this.flushPoint).build()).exceptionHandler(ClusterNotInitializedExceptionHandler.createHandler("Cannot set replication flush point")));
    }
}

