/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.commands.cdc.source.repl;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.cluster.ClusterUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.gridgain.internal.cli.call.cdc.source.DeleteSourceCall;
import org.gridgain.internal.cli.call.cdc.source.SourceNameCallInput;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"CDC source delete command."})
public class CdcSourceDeleteReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private ClusterUrlMixin clusterUrl;
    @CommandLine.Option(required=true, names={"--name"}, description={"Name of the CDC source."})
    private String name;
    @Inject
    private ConnectToClusterQuestion question;
    @Inject
    private DeleteSourceCall deleteSourceCall;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.clusterUrl.getClusterUrl()).map(this::input).then(Flows.fromCall(this.deleteSourceCall)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot delete source")).print());
    }

    private SourceNameCallInput input(String url) {
        return SourceNameCallInput.builder().clusterUrl(url).name(this.name).build();
    }
}

