/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.upgrade;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.call.UrlCallInput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.UpgradeApi;
import org.apache.ignite3.rest.client.invoker.ApiException;

@Singleton
public class UpgradeCommitCall
implements Call<UrlCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public UpgradeCommitCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(UrlCallInput input) {
        String clusterUrl = input.getUrl();
        try {
            boolean success = new UpgradeApi(this.apiClientFactory.getClient(clusterUrl)).commitUpgrade();
            if (success) {
                return DefaultCallOutput.success("Rolling upgrade has been committed.");
            }
            return DefaultCallOutput.failure(new IgniteCliException("Failed to commit rolling upgrade."));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

