/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.user;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class User {
    private final String username;
    @Nullable
    private final String password;
    private final List<String> assignedRoles;

    private User(String username, @Nullable String password, List<String> assignedRoles) {
        this.username = username;
        this.password = password;
        this.assignedRoles = assignedRoles;
    }

    public static UserBuilder builder() {
        return new UserBuilder();
    }

    public static UserBuilder builderFrom(User user) {
        return new UserBuilder().username(user.username()).assignedRoles(user.assignedRoles()).password(user.password());
    }

    public String username() {
        return this.username;
    }

    @Nullable
    public String password() {
        return this.password;
    }

    public List<String> assignedRoles() {
        return this.assignedRoles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.username, user.username) && Objects.equals(this.password, user.password) && Objects.equals(this.assignedRoles, user.assignedRoles);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password, this.assignedRoles);
    }

    public String toString() {
        return "User{username='" + this.username + "', password='" + this.password + "', assignedRoles=" + this.assignedRoles + "}";
    }

    public static class UserBuilder {
        private String username;
        private String password;
        private List<String> assignedRoles = new ArrayList<String>();

        public UserBuilder username(String username) {
            this.username = username;
            return this;
        }

        public String username() {
            return this.username;
        }

        public UserBuilder password(String password) {
            this.password = password;
            return this;
        }

        public String password() {
            return this.password;
        }

        public UserBuilder assignedRoles(List<String> assignedRoles) {
            this.assignedRoles = assignedRoles;
            return this;
        }

        public List<String> assignedRoles() {
            return this.assignedRoles;
        }

        public User build() {
            return new User(this.username, this.password, this.assignedRoles);
        }
    }
}

