/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.user;

import jakarta.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.RoleAssignmentsApi;
import org.apache.ignite3.rest.client.api.UserManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.Role;
import org.gridgain.internal.cli.call.rbac.user.ShowUserCallInput;
import org.gridgain.internal.cli.call.rbac.user.User;

@Singleton
public class GetUserCall
implements Call<ShowUserCallInput, User> {
    private final ApiClientFactory apiClientFactory;

    public GetUserCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<User> execute(ShowUserCallInput input) {
        String clusterUrl = input.url();
        try {
            User user = this.getUserRest(clusterUrl, input.username());
            if (input.showRoles()) {
                return DefaultCallOutput.success(User.builderFrom(user).assignedRoles(this.getUserRolesRest(clusterUrl, input.username())).build());
            }
            return DefaultCallOutput.success(user);
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }

    private User getUserRest(String clusterUrl, String username) throws ApiException {
        org.apache.ignite3.rest.client.model.User userDto = new UserManagementApi(this.apiClientFactory.getClient(clusterUrl)).getUser(username);
        return User.builder().username(userDto.getUsername()).build();
    }

    private List<String> getUserRolesRest(String clusterUrl, String username) throws ApiException {
        return new RoleAssignmentsApi(this.apiClientFactory.getClient(clusterUrl)).getRolesByUser(username).stream().map(Role::getRoleName).collect(Collectors.toList());
    }
}

