/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.token;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.AuthenticationApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.gridgain.internal.cli.call.rbac.token.RevokeTokenCallInput;

@Singleton
public class RevokeTokenCall
implements Call<RevokeTokenCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public RevokeTokenCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(RevokeTokenCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            String token = input.token();
            AuthenticationApi authenticationApi = new AuthenticationApi(this.apiClientFactory.getClient(clusterUrl));
            if (token != null) {
                authenticationApi.revokeToken(token);
                return DefaultCallOutput.success("Token has been revoked.");
            }
            String username = input.username();
            authenticationApi.revokeTokensByUsername(username);
            return DefaultCallOutput.success("All tokens for user " + username + " has been revoked.");
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

