/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.privilege;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class Privilege {
    private final String action;
    @Nullable
    private final String selector;

    public Privilege(String action, @Nullable String selector) {
        this.action = action;
        this.selector = selector;
    }

    public String action() {
        return this.action;
    }

    @Nullable
    public String selector() {
        return this.selector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Privilege privilege = (Privilege)o;
        return Objects.equals(this.action, privilege.action) && Objects.equals(this.selector, privilege.selector);
    }

    public int hashCode() {
        return Objects.hash(this.action, this.selector);
    }

    public String toString() {
        return "Privilege{action='" + this.action + "', selector='" + this.selector + "'}";
    }

    public static PrivilegeBuilder builder() {
        return new PrivilegeBuilder();
    }

    public static class PrivilegeBuilder {
        private String action;
        @Nullable
        private String selector;

        public PrivilegeBuilder action(String action) {
            this.action = action;
            return this;
        }

        public PrivilegeBuilder selector(@Nullable String selector) {
            this.selector = selector;
            return this;
        }

        public Privilege build() {
            return new Privilege(this.action, this.selector);
        }
    }
}

