/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.rbac.assignments;

import jakarta.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.PrivilegesGrantsApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.Privilege;
import org.apache.ignite3.rest.client.model.PrivilegeAssignment;
import org.gridgain.internal.cli.call.rbac.assignments.GrantRevokePrivilegeCallInput;
import org.gridgain.internal.cli.call.rbac.privilege.Action;

@Singleton
public class GrantPrivilegeCall
implements Call<GrantRevokePrivilegeCallInput, String> {
    private final ApiClientFactory apiClientFactory;

    public GrantPrivilegeCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<String> execute(GrantRevokePrivilegeCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            this.assignRest(clusterUrl, input.actions(), input.roleNames(), input.object());
            return DefaultCallOutput.success(GrantPrivilegeCall.formatSuccess(input.actions(), input.roleNames(), input.object()));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }

    private void assignRest(String clusterUrl, List<Action> actions, List<String> roleNames, String object) throws ApiException {
        List<Privilege> privileges = actions.stream().map(action -> new Privilege().action(action.name()).on(object)).collect(Collectors.toList());
        new PrivilegesGrantsApi(this.apiClientFactory.getClient(clusterUrl)).grantPrivileges(new PrivilegeAssignment().privileges(privileges).roleNames(roleNames));
    }

    private static String formatSuccess(List<Action> actions, List<String> roleNames, String object) {
        return (actions.size() == 1 ? "Action " : "Actions ") + actions.stream().map(Enum::name).collect(Collectors.joining(",")) + (String)(object != null ? " on " + object : "") + " granted to " + (roleNames.size() == 1 ? "role " : "roles ") + String.join((CharSequence)",", roleNames);
    }
}

