/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.license;

import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.call.UrlCallInput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.LicenseManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.License;

@Singleton
public class ShowLicenseCall
implements Call<UrlCallInput, License> {
    private final ApiClientFactory apiClientFactory;

    public ShowLicenseCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<License> execute(UrlCallInput input) {
        String clusterUrl = input.getUrl();
        try {
            return DefaultCallOutput.success(this.showLicenseRest(clusterUrl));
        }
        catch (JsonProcessingException | IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }

    private License showLicenseRest(String clusterUrl) throws ApiException, JsonProcessingException {
        return new LicenseManagementApi(this.apiClientFactory.getClient(clusterUrl)).id();
    }
}

