/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.dcr;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.DcrApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.ReplicationInfo;
import org.gridgain.internal.cli.call.dcr.ReplicationNameCallInput;

@Singleton
public class ReplicationStatusCall
implements Call<ReplicationNameCallInput, ReplicationInfo> {
    private final ApiClientFactory apiClientFactory;

    public ReplicationStatusCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<ReplicationInfo> execute(ReplicationNameCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            ReplicationInfo replicationInfo = new DcrApi(this.apiClientFactory.getClient(clusterUrl)).showReplication(input.replicationName());
            return DefaultCallOutput.success(replicationInfo);
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

