/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.dcr;

import jakarta.inject.Singleton;
import java.util.List;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.DcrApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.ReplicationInfo;
import org.gridgain.internal.cli.call.dcr.ListReplicationCallInput;

@Singleton
public class ListReplicationCall
implements Call<ListReplicationCallInput, List<ReplicationInfo>> {
    private final ApiClientFactory apiClientFactory;

    public ListReplicationCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<List<ReplicationInfo>> execute(ListReplicationCallInput input) {
        String clusterUrl = input.clusterUrl();
        try {
            List<ReplicationInfo> replicationInfos = new DcrApi(this.apiClientFactory.getClient(clusterUrl)).listReplications();
            return DefaultCallOutput.success(replicationInfos);
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

