/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.cdc.source;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.cli.core.call.CallInput;
import org.apache.ignite3.rest.client.model.SourceTable;
import org.apache.ignite3.rest.client.model.SourceType;
import org.apache.ignite3.table.QualifiedName;

public class SourceCallInput
implements CallInput {
    private final String name;
    private final String clusterUrl;
    private final SourceType type;
    private final List<String> tables;
    private final Map<String, Object> params;

    private SourceCallInput(String name, String clusterUrl, SourceType type, List<String> tables, Map<String, Object> params) {
        this.name = name;
        this.clusterUrl = clusterUrl;
        this.type = type;
        this.tables = tables;
        this.params = params;
    }

    public String name() {
        return this.name;
    }

    public String clusterUrl() {
        return this.clusterUrl;
    }

    public SourceType type() {
        return this.type;
    }

    public List<SourceTable> tables() {
        return this.tables.stream().map(s -> {
            QualifiedName qname = QualifiedName.parse(s);
            return new SourceTable().schema(qname.schemaName()).name(qname.objectName());
        }).collect(Collectors.toList());
    }

    public Map<String, Object> params() {
        return this.params;
    }

    public static SourceCallInputBuilder builder() {
        return new SourceCallInputBuilder();
    }

    public static class SourceCallInputBuilder {
        private String name;
        private String clusterUrl;
        private SourceType type;
        private List<String> tables;
        private Map<String, Object> params;

        public SourceCallInputBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SourceCallInputBuilder clusterUrl(String clusterUrl) {
            this.clusterUrl = clusterUrl;
            return this;
        }

        public SourceCallInputBuilder type(SourceType type) {
            this.type = type;
            return this;
        }

        public SourceCallInputBuilder tables(List<String> tables) {
            this.tables = tables;
            return this;
        }

        public SourceCallInputBuilder parameters(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public SourceCallInput build() {
            return new SourceCallInput(this.name, this.clusterUrl, this.type, this.tables, this.params);
        }
    }
}

