/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cli.call.cdc.sink;

import jakarta.inject.Singleton;
import java.util.List;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.CallOutput;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.call.UrlCallInput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.CdcManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.model.Sink;

@Singleton
public class ListSinksCall
implements Call<UrlCallInput, List<Sink>> {
    private final ApiClientFactory apiClientFactory;

    public ListSinksCall(ApiClientFactory apiClientFactory) {
        this.apiClientFactory = apiClientFactory;
    }

    @Override
    public CallOutput<List<Sink>> execute(UrlCallInput input) {
        String clusterUrl = input.getUrl();
        try {
            return DefaultCallOutput.success(new CdcManagementApi(this.apiClientFactory.getClient(clusterUrl)).getSinks());
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, clusterUrl));
        }
    }
}

