/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.core.sink;

import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.mapper.TypeConverter;
import org.gridgain.internal.cdc.api.exception.CdcInternalException;
import org.gridgain.internal.cdc.api.sink.SinkDefinition;
import org.gridgain.internal.cdc.api.sink.SinkParameters;
import org.gridgain.internal.cdc.api.sink.SinkType;
import org.gridgain.internal.cdc.core.converters.JsonConverter;
import org.gridgain.internal.cdc.core.sink.SinkDefinitionValue;

public final class SinkDefinitionMappings {
    public static final String SINK_TYPE_COL = "TYPE";
    public static final String SINK_PARAMETERS_COL = "PARAMETERS";
    public static final String SINK_NAME_COL = "NAME";
    public static final String SINK_CREATE_TABLE_IF_NOT_EXISTS_COL = "CREATE_TABLE_IF_NOT_EXISTS";

    public static Mapper<SinkDefinitionValue> valueMapper() {
        Mapper<SinkDefinitionValue> mapper = Mapper.builder(SinkDefinitionValue.class).map("type", SINK_TYPE_COL, new String[0]).map("parameters", SINK_PARAMETERS_COL, new String[0]).map("createTableIfNotExists", SINK_CREATE_TABLE_IF_NOT_EXISTS_COL, new String[0]).convert("type", new SinkTypeConverter()).convert("parameters", new JsonConverter<SinkParameters>(SinkParameters.class)).build();
        return mapper;
    }

    public static Mapper<SinkDefinition> recordMapper() {
        Mapper<SinkDefinition> mapper = Mapper.builder(SinkDefinition.class).map("name", SINK_NAME_COL, new String[0]).map("type", SINK_TYPE_COL, new String[0]).map("parameters", SINK_PARAMETERS_COL, new String[0]).map("createTableIfNotExists", SINK_CREATE_TABLE_IF_NOT_EXISTS_COL, new String[0]).convert("type", new SinkTypeConverter()).convert("parameters", new JsonConverter<SinkParameters>(SinkParameters.class)).build();
        return mapper;
    }

    static class SinkTypeConverter
    implements TypeConverter<SinkType, Short> {
        SinkTypeConverter() {
        }

        @Override
        public Short toColumnType(SinkType obj) throws Exception {
            switch (obj) {
                case ICEBERG: {
                    return (short)0;
                }
                case GRIDGAIN_8: {
                    return (short)1;
                }
            }
            throw new CdcInternalException("Unsupported sink type: " + obj);
        }

        @Override
        public SinkType toObjectType(Short data) throws Exception {
            switch (data) {
                case 0: {
                    return SinkType.ICEBERG;
                }
                case 1: {
                    return SinkType.GRIDGAIN_8;
                }
            }
            throw new CdcInternalException("Unsupported sink type: " + data);
        }
    }
}

