/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.core.replication;

import java.util.List;
import java.util.stream.Collectors;
import org.gridgain.internal.cdc.api.replication.CdcReplicationDefinition;
import org.gridgain.internal.cdc.api.replication.CdcReplicationExecNodes;
import org.gridgain.internal.cdc.api.replication.CdcReplicationInstance;
import org.gridgain.internal.cdc.api.replication.CdcReplicationMode;
import org.gridgain.internal.cdc.api.replication.CdcReplicationStatus;

public class CdcReplicationInstanceValue {
    private String sinkName;
    private String sourceName;
    private CdcReplicationMode mode;
    private CdcReplicationExecNodes executionNodes = CdcReplicationExecNodes.any();
    private CdcReplicationStatus status;
    private String runningOnNodeId;
    private String errorContext;

    public CdcReplicationInstanceValue() {
    }

    private CdcReplicationInstanceValue(String sinkName, String sourceName, CdcReplicationMode mode, CdcReplicationExecNodes executionNodes, CdcReplicationStatus status, String runningOnNodeId, String errorContext) {
        this.sinkName = sinkName;
        this.sourceName = sourceName;
        this.mode = mode;
        this.executionNodes = executionNodes;
        this.status = status;
        this.runningOnNodeId = runningOnNodeId;
        this.errorContext = errorContext;
    }

    public String sinkName() {
        return this.sinkName;
    }

    public String sourceName() {
        return this.sourceName;
    }

    public CdcReplicationMode mode() {
        return this.mode;
    }

    public CdcReplicationExecNodes executionNodes() {
        return this.executionNodes;
    }

    public CdcReplicationStatus status() {
        return this.status;
    }

    public String runningOnNodeId() {
        return this.runningOnNodeId;
    }

    public String errorContext() {
        return this.errorContext;
    }

    public static CdcReplicationInstanceValue from(CdcReplicationInstance instance) {
        return new CdcReplicationInstanceValue(instance.sinkName(), instance.sourceName(), instance.mode(), instance.executionNodes(), instance.status(), instance.runningOnNodeId(), instance.errorContext());
    }

    public static CdcReplicationInstanceValue from(CdcReplicationDefinition definition) {
        if (definition.executionNodes() == null || definition.executionNodes().nodes() == null || definition.executionNodes().nodes().isEmpty()) {
            throw new IllegalArgumentException("Execution nodes must be specified and cannot be empty.");
        }
        List sortedExecutorNodes = definition.executionNodes().nodes().stream().sorted().collect(Collectors.toList());
        return new CdcReplicationInstanceValue(definition.sinkName(), definition.sourceName(), definition.mode(), definition.executionNodes(), CdcReplicationStatus.CREATED, (String)sortedExecutorNodes.get(0), null);
    }

    public CdcReplicationInstance toReplicationInstance(String replicationName) {
        return CdcReplicationInstance.builder().name(replicationName).sinkName(this.sinkName).sourceName(this.sourceName).mode(this.mode).executionNodes(this.executionNodes).status(this.status).runningOnNodeId(this.runningOnNodeId).errorContext(this.errorContext).build();
    }
}

