/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.api.sink;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.gridgain.internal.cdc.api.sink.SinkParameters;
import org.gridgain.internal.cdc.api.sink.SinkType;
import org.jetbrains.annotations.Nullable;

public class SinkDefinition {
    private String name;
    private SinkType type;
    private boolean createTableIfNotExists = true;
    private SinkParameters parameters;

    public SinkDefinition() {
    }

    private SinkDefinition(SinkType type, String name, boolean createTableIfNotExists, SinkParameters parameters) {
        this.type = type;
        this.name = name;
        this.createTableIfNotExists = createTableIfNotExists;
        this.parameters = parameters;
    }

    public SinkType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public SinkParameters parameters() {
        return this.parameters;
    }

    public boolean createTableIfNotExists() {
        return this.createTableIfNotExists;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SinkDefinition that = (SinkDefinition)o;
        return this.createTableIfNotExists == that.createTableIfNotExists && Objects.equals(this.name, that.name) && this.type == that.type && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.createTableIfNotExists, this.parameters});
    }

    public String toString() {
        return "SinkDefinition{name='" + this.name + "', type=" + this.type + ", createTableIfNotExists=" + this.createTableIfNotExists + ", parameters=" + this.parameters + "}";
    }

    public static SinkDefinitionBuilder builder() {
        return new SinkDefinitionBuilder();
    }

    public static SinkDefinitionBuilder builderFrom(SinkDefinition icebergSinkDefinition) {
        return new SinkDefinitionBuilder().type(icebergSinkDefinition.type()).name(icebergSinkDefinition.name()).createTableIfNotExists(icebergSinkDefinition.createTableIfNotExists()).parameters(icebergSinkDefinition.parameters());
    }

    public static class SinkDefinitionBuilder {
        private SinkType type;
        private String name;
        private boolean createTableIfNotExists = true;
        private SinkParameters parameters = new SinkParameters(new HashMap<String, String>());

        public SinkDefinitionBuilder type(SinkType type) {
            this.type = type;
            return this;
        }

        public SinkDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SinkDefinitionBuilder createTableIfNotExists(boolean createTableIfNotExists) {
            this.createTableIfNotExists = createTableIfNotExists;
            return this;
        }

        public SinkDefinitionBuilder parameters(Map<String, String> parameters) {
            if (parameters == null) {
                parameters = new HashMap<String, String>();
            }
            this.parameters = new SinkParameters(parameters);
            return this;
        }

        public SinkDefinitionBuilder parameters(@Nullable SinkParameters parameters) {
            if (parameters == null) {
                parameters = new SinkParameters(new HashMap<String, String>());
            }
            this.parameters = parameters;
            return this;
        }

        public SinkDefinition build() {
            return new SinkDefinition(this.type, this.name, this.createTableIfNotExists, this.parameters);
        }
    }
}

