/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.cdc.api.replication;

import org.gridgain.internal.cdc.api.exception.CdcValidationException;
import org.gridgain.internal.cdc.api.replication.CdcReplicationExecNodes;
import org.gridgain.internal.cdc.api.replication.CdcReplicationMode;

public class CdcReplicationDefinition {
    private String name;
    private String sinkName;
    private String sourceName;
    private CdcReplicationMode mode;
    private CdcReplicationExecNodes executionNodes;

    public CdcReplicationDefinition() {
    }

    private CdcReplicationDefinition(String name, String sinkName, String sourceName, CdcReplicationMode mode, CdcReplicationExecNodes executionNodes) {
        this.name = name;
        this.sinkName = sinkName;
        this.sourceName = sourceName;
        this.mode = mode;
        this.executionNodes = executionNodes;
    }

    public String name() {
        return this.name;
    }

    public String sinkName() {
        return this.sinkName;
    }

    public String sourceName() {
        return this.sourceName;
    }

    public CdcReplicationMode mode() {
        return this.mode;
    }

    public CdcReplicationExecNodes executionNodes() {
        return this.executionNodes;
    }

    public static ReplicationDefinitionBuilder builder() {
        return new ReplicationDefinitionBuilder();
    }

    public static ReplicationDefinitionBuilder builderFrom(CdcReplicationDefinition definition) {
        return definition.toBuilder();
    }

    public ReplicationDefinitionBuilder toBuilder() {
        return new ReplicationDefinitionBuilder().name(this.name).sinkName(this.sinkName).sourceName(this.sourceName).mode(this.mode).executionNodes(this.executionNodes);
    }

    public static class ReplicationDefinitionBuilder {
        private String name;
        private String sinkName;
        private String sourceName;
        private CdcReplicationMode mode = CdcReplicationMode.ALL;
        private CdcReplicationExecNodes executionNodes = CdcReplicationExecNodes.any();

        public ReplicationDefinitionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ReplicationDefinitionBuilder sinkName(String sinkName) {
            this.sinkName = sinkName;
            return this;
        }

        public ReplicationDefinitionBuilder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public ReplicationDefinitionBuilder mode(CdcReplicationMode mode) {
            this.mode = mode;
            return this;
        }

        public ReplicationDefinitionBuilder executionNodes(CdcReplicationExecNodes executionNodes) {
            this.executionNodes = executionNodes;
            return this;
        }

        public CdcReplicationDefinition build() {
            if (this.name == null || this.name.isEmpty()) {
                throw new CdcValidationException("Replication name cannot be null or empty.");
            }
            if (this.sinkName == null || this.sinkName.isEmpty()) {
                throw new CdcValidationException("Sink name cannot be null or empty.");
            }
            if (this.sourceName == null || this.sourceName.isEmpty()) {
                throw new CdcValidationException("Source name cannot be null or empty.");
            }
            if (this.mode == null) {
                throw new CdcValidationException("Replication mode cannot be null.");
            }
            if (this.executionNodes == null) {
                throw new CdcValidationException("Execution nodes cannot be null.");
            }
            return new CdcReplicationDefinition(this.name, this.sinkName, this.sourceName, this.mode, this.executionNodes);
        }
    }
}

