/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.table;

import org.apache.ignite3.table.KeyValueView;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.RecordView;
import org.apache.ignite3.table.TableViewOptions;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.partition.PartitionDistribution;
import org.apache.ignite3.table.partition.PartitionManager;

public interface Table {
    default public String name() {
        return this.qualifiedName().toCanonicalForm();
    }

    public QualifiedName qualifiedName();

    @Deprecated(forRemoval=true, since="3.2")
    public PartitionManager partitionManager();

    public PartitionDistribution partitionDistribution();

    public <R> RecordView<R> recordView(Mapper<R> var1);

    public RecordView<Tuple> recordView();

    default public <R> RecordView<R> recordView(Class<R> recCls) {
        return this.recordView(Mapper.of(recCls));
    }

    public <R> RecordView<R> recordView(Mapper<R> var1, TableViewOptions var2);

    public RecordView<Tuple> recordView(TableViewOptions var1);

    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> var1, Mapper<V> var2);

    public KeyValueView<Tuple, Tuple> keyValueView();

    default public <K, V> KeyValueView<K, V> keyValueView(Class<K> keyCls, Class<V> valCls) {
        return this.keyValueView(Mapper.of(keyCls), Mapper.of(valCls));
    }

    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> var1, Mapper<V> var2, TableViewOptions var3);

    public KeyValueView<Tuple, Tuple> keyValueView(TableViewOptions var1);
}

