/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.rest.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.ignite3.rest.client.invoker.JSON;

public class TablesRecoveryRequest {
    public static final String SERIALIZED_NAME_TABLES = "tables";
    @SerializedName(value="tables")
    @Nonnull
    private List<String> tables = new ArrayList<String>();
    public static final String SERIALIZED_NAME_TIMESTAMP = "timestamp";
    @SerializedName(value="timestamp")
    @Nonnull
    private OffsetDateTime timestamp;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("tables", "timestamp"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("tables", "timestamp"));

    public TablesRecoveryRequest tables(@Nonnull List<String> tables) {
        this.tables = tables;
        return this;
    }

    public TablesRecoveryRequest addTablesItem(String tablesItem) {
        if (this.tables == null) {
            this.tables = new ArrayList<String>();
        }
        this.tables.add(tablesItem);
        return this;
    }

    @Nonnull
    public List<String> getTables() {
        return this.tables;
    }

    public void setTables(@Nonnull List<String> tables) {
        this.tables = tables;
    }

    public TablesRecoveryRequest timestamp(@Nonnull OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nonnull
    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(@Nonnull OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TablesRecoveryRequest tablesRecoveryRequest = (TablesRecoveryRequest)o;
        return Objects.equals(this.tables, tablesRecoveryRequest.tables) && Objects.equals(this.timestamp, tablesRecoveryRequest.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.tables, this.timestamp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TablesRecoveryRequest {\n");
        sb.append("    tables: ").append(this.toIndentedString(this.tables)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in TablesRecoveryRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` in the JSON string is not defined in the `TablesRecoveryRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_TABLES) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TABLES).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `tables` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TABLES).toString()));
        }
    }

    public static TablesRecoveryRequest fromJson(String jsonString) throws IOException {
        return (TablesRecoveryRequest)JSON.getGson().fromJson(jsonString, TablesRecoveryRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TablesRecoveryRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TablesRecoveryRequest.class));
            return new TypeAdapter<TablesRecoveryRequest>(){

                public void write(JsonWriter out, TablesRecoveryRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TablesRecoveryRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    TablesRecoveryRequest.validateJsonElement(jsonElement);
                    return (TablesRecoveryRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

