/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.rest.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.ignite3.rest.client.invoker.JSON;
import org.apache.ignite3.rest.client.model.Privilege;

public class RolePrivileges {
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    @Nullable
    private String role;
    public static final String SERIALIZED_NAME_PRIVILEGES = "privileges";
    @SerializedName(value="privileges")
    @Nonnull
    private List<Privilege> privileges = new ArrayList<Privilege>();
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("role", "privileges"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("privileges"));

    public RolePrivileges role(@Nullable String role) {
        this.role = role;
        return this;
    }

    @Nullable
    public String getRole() {
        return this.role;
    }

    public void setRole(@Nullable String role) {
        this.role = role;
    }

    public RolePrivileges privileges(@Nonnull List<Privilege> privileges) {
        this.privileges = privileges;
        return this;
    }

    public RolePrivileges addPrivilegesItem(Privilege privilegesItem) {
        if (this.privileges == null) {
            this.privileges = new ArrayList<Privilege>();
        }
        this.privileges.add(privilegesItem);
        return this;
    }

    @Nonnull
    public List<Privilege> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(@Nonnull List<Privilege> privileges) {
        this.privileges = privileges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolePrivileges rolePrivileges = (RolePrivileges)o;
        return Objects.equals(this.role, rolePrivileges.role) && Objects.equals(this.privileges, rolePrivileges.privileges);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.privileges);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RolePrivileges {\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    privileges: ").append(this.toIndentedString(this.privileges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in RolePrivileges is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` in the JSON string is not defined in the `RolePrivileges` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ROLE) != null && !jsonObj.get(SERIALIZED_NAME_ROLE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ROLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `role` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PRIVILEGES).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `privileges` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIVILEGES).toString()));
        }
        JsonArray jsonArrayprivileges = jsonObj.getAsJsonArray(SERIALIZED_NAME_PRIVILEGES);
        for (int i = 0; i < jsonArrayprivileges.size(); ++i) {
            Privilege.validateJsonElement(jsonArrayprivileges.get(i));
        }
    }

    public static RolePrivileges fromJson(String jsonString) throws IOException {
        return (RolePrivileges)JSON.getGson().fromJson(jsonString, RolePrivileges.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!RolePrivileges.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(RolePrivileges.class));
            return new TypeAdapter<RolePrivileges>(){

                public void write(JsonWriter out, RolePrivileges value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public RolePrivileges read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    RolePrivileges.validateJsonElement(jsonElement);
                    return (RolePrivileges)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

