/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import okhttp3.Call;
import org.apache.ignite3.rest.client.invoker.ApiCallback;
import org.apache.ignite3.rest.client.invoker.ApiClient;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.invoker.ApiResponse;
import org.apache.ignite3.rest.client.invoker.Configuration;
import org.apache.ignite3.rest.client.invoker.Pair;
import org.apache.ignite3.rest.client.model.CreateUserRequest;
import org.apache.ignite3.rest.client.model.User;

public class UserManagementApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public UserManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserManagementApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call createUserCall(@Nonnull CreateUserRequest createUserRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateUserRequest localVarPostBody = createUserRequest;
        String localVarPath = "/management/v1/rbac/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createUserValidateBeforeCall(@Nonnull CreateUserRequest createUserRequest, ApiCallback _callback) throws ApiException {
        if (createUserRequest == null) {
            throw new ApiException("Missing the required parameter 'createUserRequest' when calling createUser(Async)");
        }
        return this.createUserCall(createUserRequest, _callback);
    }

    public void createUser(@Nonnull CreateUserRequest createUserRequest) throws ApiException {
        this.createUserWithHttpInfo(createUserRequest);
    }

    public ApiResponse<Void> createUserWithHttpInfo(@Nonnull CreateUserRequest createUserRequest) throws ApiException {
        Call localVarCall = this.createUserValidateBeforeCall(createUserRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call createUserAsync(@Nonnull CreateUserRequest createUserRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.createUserValidateBeforeCall(createUserRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteUserCall(@Nonnull String username, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/rbac/users/{username}".replace("{username}", this.localVarApiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteUserValidateBeforeCall(@Nonnull String username, ApiCallback _callback) throws ApiException {
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling deleteUser(Async)");
        }
        return this.deleteUserCall(username, _callback);
    }

    public void deleteUser(@Nonnull String username) throws ApiException {
        this.deleteUserWithHttpInfo(username);
    }

    public ApiResponse<Void> deleteUserWithHttpInfo(@Nonnull String username) throws ApiException {
        Call localVarCall = this.deleteUserValidateBeforeCall(username, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteUserAsync(@Nonnull String username, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteUserValidateBeforeCall(username, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call getUserCall(@Nonnull String username, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/rbac/users/{username}".replace("{username}", this.localVarApiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUserValidateBeforeCall(@Nonnull String username, ApiCallback _callback) throws ApiException {
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling getUser(Async)");
        }
        return this.getUserCall(username, _callback);
    }

    public User getUser(@Nonnull String username) throws ApiException {
        ApiResponse<User> localVarResp = this.getUserWithHttpInfo(username);
        return localVarResp.getData();
    }

    public ApiResponse<User> getUserWithHttpInfo(@Nonnull String username) throws ApiException {
        Call localVarCall = this.getUserValidateBeforeCall(username, null);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUserAsync(@Nonnull String username, ApiCallback<User> _callback) throws ApiException {
        Call localVarCall = this.getUserValidateBeforeCall(username, _callback);
        Type localVarReturnType = new TypeToken<User>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getUsersCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/rbac/users";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getUsersValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getUsersCall(_callback);
    }

    public List<User> getUsers() throws ApiException {
        ApiResponse<List<User>> localVarResp = this.getUsersWithHttpInfo();
        return localVarResp.getData();
    }

    public ApiResponse<List<User>> getUsersWithHttpInfo() throws ApiException {
        Call localVarCall = this.getUsersValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getUsersAsync(ApiCallback<List<User>> _callback) throws ApiException {
        Call localVarCall = this.getUsersValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<List<User>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateUserCall(@Nonnull String username, @Nonnull CreateUserRequest createUserRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        CreateUserRequest localVarPostBody = createUserRequest;
        String localVarPath = "/management/v1/rbac/users/{username}".replace("{username}", this.localVarApiClient.escapeString(username.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateUserValidateBeforeCall(@Nonnull String username, @Nonnull CreateUserRequest createUserRequest, ApiCallback _callback) throws ApiException {
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling updateUser(Async)");
        }
        if (createUserRequest == null) {
            throw new ApiException("Missing the required parameter 'createUserRequest' when calling updateUser(Async)");
        }
        return this.updateUserCall(username, createUserRequest, _callback);
    }

    public void updateUser(@Nonnull String username, @Nonnull CreateUserRequest createUserRequest) throws ApiException {
        this.updateUserWithHttpInfo(username, createUserRequest);
    }

    public ApiResponse<Void> updateUserWithHttpInfo(@Nonnull String username, @Nonnull CreateUserRequest createUserRequest) throws ApiException {
        Call localVarCall = this.updateUserValidateBeforeCall(username, createUserRequest, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateUserAsync(@Nonnull String username, @Nonnull CreateUserRequest createUserRequest, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateUserValidateBeforeCall(username, createUserRequest, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

