/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import org.apache.ignite3.rest.client.invoker.ApiCallback;
import org.apache.ignite3.rest.client.invoker.ApiClient;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.invoker.ApiResponse;
import org.apache.ignite3.rest.client.invoker.Configuration;
import org.apache.ignite3.rest.client.invoker.Pair;

public class DataNodesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public DataNodesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DataNodesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call getDataNodesForZoneCall(@Nonnull String zoneName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/zones/{zoneName}/datanodes".replace("{zoneName}", this.localVarApiClient.escapeString(zoneName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getDataNodesForZoneValidateBeforeCall(@Nonnull String zoneName, ApiCallback _callback) throws ApiException {
        if (zoneName == null) {
            throw new ApiException("Missing the required parameter 'zoneName' when calling getDataNodesForZone(Async)");
        }
        return this.getDataNodesForZoneCall(zoneName, _callback);
    }

    public Set<String> getDataNodesForZone(@Nonnull String zoneName) throws ApiException {
        ApiResponse<Set<String>> localVarResp = this.getDataNodesForZoneWithHttpInfo(zoneName);
        return localVarResp.getData();
    }

    public ApiResponse<Set<String>> getDataNodesForZoneWithHttpInfo(@Nonnull String zoneName) throws ApiException {
        Call localVarCall = this.getDataNodesForZoneValidateBeforeCall(zoneName, null);
        Type localVarReturnType = new TypeToken<Set<String>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getDataNodesForZoneAsync(@Nonnull String zoneName, ApiCallback<Set<String>> _callback) throws ApiException {
        Call localVarCall = this.getDataNodesForZoneValidateBeforeCall(zoneName, _callback);
        Type localVarReturnType = new TypeToken<Set<String>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call resetDataNodesForZoneCall(@Nonnull String zoneName, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/zones/{zoneName}/datanodes/reset".replace("{zoneName}", this.localVarApiClient.escapeString(zoneName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resetDataNodesForZoneValidateBeforeCall(@Nonnull String zoneName, ApiCallback _callback) throws ApiException {
        if (zoneName == null) {
            throw new ApiException("Missing the required parameter 'zoneName' when calling resetDataNodesForZone(Async)");
        }
        return this.resetDataNodesForZoneCall(zoneName, _callback);
    }

    public void resetDataNodesForZone(@Nonnull String zoneName) throws ApiException {
        this.resetDataNodesForZoneWithHttpInfo(zoneName);
    }

    public ApiResponse<Void> resetDataNodesForZoneWithHttpInfo(@Nonnull String zoneName) throws ApiException {
        Call localVarCall = this.resetDataNodesForZoneValidateBeforeCall(zoneName, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call resetDataNodesForZoneAsync(@Nonnull String zoneName, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.resetDataNodesForZoneValidateBeforeCall(zoneName, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call resetDataNodesForZonesCall(@Nullable List<String> requestBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        List<String> localVarPostBody = requestBody;
        String localVarPath = "/management/v1/zones/datanodes/reset";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call resetDataNodesForZonesValidateBeforeCall(@Nullable List<String> requestBody, ApiCallback _callback) throws ApiException {
        return this.resetDataNodesForZonesCall(requestBody, _callback);
    }

    public void resetDataNodesForZones(@Nullable List<String> requestBody) throws ApiException {
        this.resetDataNodesForZonesWithHttpInfo(requestBody);
    }

    public ApiResponse<Void> resetDataNodesForZonesWithHttpInfo(@Nullable List<String> requestBody) throws ApiException {
        Call localVarCall = this.resetDataNodesForZonesValidateBeforeCall(requestBody, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call resetDataNodesForZonesAsync(@Nullable List<String> requestBody, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.resetDataNodesForZonesValidateBeforeCall(requestBody, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

