/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nonnull;
import okhttp3.Call;
import org.apache.ignite3.rest.client.invoker.ApiCallback;
import org.apache.ignite3.rest.client.invoker.ApiClient;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.apache.ignite3.rest.client.invoker.ApiResponse;
import org.apache.ignite3.rest.client.invoker.Configuration;
import org.apache.ignite3.rest.client.invoker.Pair;
import org.apache.ignite3.rest.client.model.LoginBody;

public class AuthenticationApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AuthenticationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthenticationApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call loginCall(@Nonnull LoginBody loginBody, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        LoginBody localVarPostBody = loginBody;
        String localVarPath = "/management/v1/authentication/login";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/jwt", "application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call loginValidateBeforeCall(@Nonnull LoginBody loginBody, ApiCallback _callback) throws ApiException {
        if (loginBody == null) {
            throw new ApiException("Missing the required parameter 'loginBody' when calling login(Async)");
        }
        return this.loginCall(loginBody, _callback);
    }

    public String login(@Nonnull LoginBody loginBody) throws ApiException {
        ApiResponse<String> localVarResp = this.loginWithHttpInfo(loginBody);
        return localVarResp.getData();
    }

    public ApiResponse<String> loginWithHttpInfo(@Nonnull LoginBody loginBody) throws ApiException {
        Call localVarCall = this.loginValidateBeforeCall(loginBody, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call loginAsync(@Nonnull LoginBody loginBody, ApiCallback<String> _callback) throws ApiException {
        Call localVarCall = this.loginValidateBeforeCall(loginBody, _callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call revokeTokenCall(@Nonnull String token, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/authentication/jwt/{token}".replace("{token}", this.localVarApiClient.escapeString(token.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/problem+json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call revokeTokenValidateBeforeCall(@Nonnull String token, ApiCallback _callback) throws ApiException {
        if (token == null) {
            throw new ApiException("Missing the required parameter 'token' when calling revokeToken(Async)");
        }
        return this.revokeTokenCall(token, _callback);
    }

    public void revokeToken(@Nonnull String token) throws ApiException {
        this.revokeTokenWithHttpInfo(token);
    }

    public ApiResponse<Void> revokeTokenWithHttpInfo(@Nonnull String token) throws ApiException {
        Call localVarCall = this.revokeTokenValidateBeforeCall(token, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call revokeTokenAsync(@Nonnull String token, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.revokeTokenValidateBeforeCall(token, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call revokeTokensByUsernameCall(@Nonnull String username, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/management/v1/authentication/jwt";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (username != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("username", username));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/problem+json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"bearerToken", "basicAuth"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call revokeTokensByUsernameValidateBeforeCall(@Nonnull String username, ApiCallback _callback) throws ApiException {
        if (username == null) {
            throw new ApiException("Missing the required parameter 'username' when calling revokeTokensByUsername(Async)");
        }
        return this.revokeTokensByUsernameCall(username, _callback);
    }

    public void revokeTokensByUsername(@Nonnull String username) throws ApiException {
        this.revokeTokensByUsernameWithHttpInfo(username);
    }

    public ApiResponse<Void> revokeTokensByUsernameWithHttpInfo(@Nonnull String username) throws ApiException {
        Call localVarCall = this.revokeTokensByUsernameValidateBeforeCall(username, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call revokeTokensByUsernameAsync(@Nonnull String username, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.revokeTokensByUsernameValidateBeforeCall(username, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

