/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import java.util.Collection;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.rpc.CliRequests;
import org.apache.ignite3.raft.jraft.rpc.RemovePeerResponseBuilder;

class RemovePeerResponseDeserializer
implements MessageDeserializer<CliRequests.RemovePeerResponse> {
    private final RemovePeerResponseBuilder msg;

    RemovePeerResponseDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.removePeerResponse();
    }

    @Override
    public Class<CliRequests.RemovePeerResponse> klass() {
        return CliRequests.RemovePeerResponse.class;
    }

    @Override
    public CliRequests.RemovePeerResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(RaftMessagesTypeInfos.removePeerResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readCollection("newPeersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.newPeersList((Collection<String>)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readCollection("oldPeersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.oldPeersList((Collection<String>)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CliRequests.RemovePeerResponse.class);
    }
}

