/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.raft.jraft.RaftMessagesTypeInfos;
import org.apache.ignite3.raft.jraft.rpc.AppendEntriesRequestImpl;
import org.apache.ignite3.raft.jraft.rpc.RpcRequests;

class AppendEntriesRequestSerializer
implements MessageSerializer<RpcRequests.AppendEntriesRequest> {
    public static final AppendEntriesRequestSerializer INSTANCE = new AppendEntriesRequestSerializer();

    private AppendEntriesRequestSerializer() {
    }

    @Override
    public boolean writeMessage(RpcRequests.AppendEntriesRequest msg, MessageWriter writer) throws MessageMappingException {
        AppendEntriesRequestImpl message = (AppendEntriesRequestImpl)msg;
        writer.setMessageTypeInfo(RaftMessagesTypeInfos.appendEntriesRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)10)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeLong("committedIndex", message.committedIndex());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeByteBuffer("data", message.data());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeCollection("entriesList", message.entriesList(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeString("groupId", message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeString("peerId", message.peerId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeLong("prevLogIndex", message.prevLogIndex());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeLong("prevLogTerm", message.prevLogTerm());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                boolean written = writer.writeString("serverId", message.serverId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                boolean written = writer.writeLong("term", message.term());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

