/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.entity.codec.v1;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.apache.ignite3.internal.raft.util.VarlenEncoder;
import org.apache.ignite3.internal.util.GridUnsafe;
import org.apache.ignite3.raft.jraft.entity.EnumOutter;
import org.apache.ignite3.raft.jraft.entity.LogEntry;
import org.apache.ignite3.raft.jraft.entity.LogId;
import org.apache.ignite3.raft.jraft.entity.PeerId;
import org.apache.ignite3.raft.jraft.entity.codec.LogEntryEncoder;
import org.apache.ignite3.raft.jraft.util.AsciiStringUtil;
import org.apache.ignite3.raft.jraft.util.Bits;
import org.jetbrains.annotations.Nullable;

public final class V1Encoder
implements LogEntryEncoder {
    public static final V1Encoder INSTANCE = new V1Encoder();

    private V1Encoder() {
    }

    @Override
    public int size(LogEntry logEntry) {
        EnumOutter.EntryType type = logEntry.getType();
        LogId id = logEntry.getId();
        List<PeerId> peers = logEntry.getPeers();
        List<PeerId> oldPeers = logEntry.getOldPeers();
        List<PeerId> learners = logEntry.getLearners();
        List<PeerId> oldLearners = logEntry.getOldLearners();
        ByteBuffer data = logEntry.getData();
        int totalLen = 1;
        int typeNumber = type.getNumber();
        long index = id.getIndex();
        long term = id.getTerm();
        totalLen += VarlenEncoder.sizeInBytes(typeNumber) + VarlenEncoder.sizeInBytes(index) + VarlenEncoder.sizeInBytes(term) + 8;
        if (type != EnumOutter.EntryType.ENTRY_TYPE_DATA) {
            totalLen += V1Encoder.nodesListSizeInBytes(peers);
            totalLen += V1Encoder.nodesListSizeInBytes(oldPeers);
            totalLen += V1Encoder.nodesListSizeInBytes(learners);
            totalLen += V1Encoder.nodesListSizeInBytes(oldLearners);
        }
        if (type != EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION) {
            int bodyLen = data != null ? data.remaining() : 0;
            totalLen += bodyLen;
        }
        return totalLen;
    }

    public void append(long addr, LogEntry logEntry) {
        EnumOutter.EntryType type = logEntry.getType();
        LogId id = logEntry.getId();
        List<PeerId> peers = logEntry.getPeers();
        List<PeerId> oldPeers = logEntry.getOldPeers();
        List<PeerId> learners = logEntry.getLearners();
        List<PeerId> oldLearners = logEntry.getOldLearners();
        ByteBuffer data = logEntry.getData();
        int typeNumber = type.getNumber();
        long index = id.getIndex();
        long term = id.getTerm();
        GridUnsafe.putByte(addr++, (byte)-72);
        addr += (long)VarlenEncoder.writeLong((long)typeNumber, addr);
        addr += (long)VarlenEncoder.writeLong(index, addr);
        addr += (long)VarlenEncoder.writeLong(term, addr);
        Bits.putLongLittleEndian(addr, logEntry.getChecksum());
        addr += 8L;
        if (type != EnumOutter.EntryType.ENTRY_TYPE_DATA) {
            addr = V1Encoder.writeNodesList(addr, peers);
            addr = V1Encoder.writeNodesList(addr, oldPeers);
            addr = V1Encoder.writeNodesList(addr, learners);
            addr = V1Encoder.writeNodesList(addr, oldLearners);
        }
        if (type != EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION && data != null) {
            GridUnsafe.copyHeapOffheap(data.array(), (long)data.position() + GridUnsafe.BYTE_ARR_OFF, addr, data.remaining());
        }
    }

    @Override
    public byte[] encode(LogEntry log) {
        int totalLen = this.size(log);
        ByteBuffer buffer = ByteBuffer.allocate(totalLen).order(ByteOrder.LITTLE_ENDIAN);
        this.encode(buffer, log);
        return buffer.array();
    }

    @Override
    public void encode(ByteBuffer buffer, LogEntry log) {
        EnumOutter.EntryType type = log.getType();
        LogId id = log.getId();
        List<PeerId> peers = log.getPeers();
        List<PeerId> oldPeers = log.getOldPeers();
        List<PeerId> learners = log.getLearners();
        List<PeerId> oldLearners = log.getOldLearners();
        ByteBuffer data = log.getReadOnlyData();
        int typeNumber = type.getNumber();
        long index = id.getIndex();
        long term = id.getTerm();
        buffer.put((byte)-72);
        VarlenEncoder.writeLong((long)typeNumber, buffer);
        VarlenEncoder.writeLong(index, buffer);
        VarlenEncoder.writeLong(term, buffer);
        buffer.putLong(log.getChecksum());
        if (type != EnumOutter.EntryType.ENTRY_TYPE_DATA) {
            V1Encoder.writeNodesList(buffer, peers);
            V1Encoder.writeNodesList(buffer, oldPeers);
            V1Encoder.writeNodesList(buffer, learners);
            V1Encoder.writeNodesList(buffer, oldLearners);
        }
        if (type != EnumOutter.EntryType.ENTRY_TYPE_CONFIGURATION && data != null) {
            buffer.put(data);
        }
    }

    private static int nodesListSizeInBytes(@Nullable List<PeerId> nodes) {
        if (nodes == null) {
            return 1;
        }
        int size = 0;
        for (PeerId node : nodes) {
            String consistentId = node.getConsistentId();
            size += 2 + consistentId.length() + VarlenEncoder.sizeInBytes(node.getIdx()) + VarlenEncoder.sizeInBytes(node.getPriority() + 1);
        }
        return size + VarlenEncoder.sizeInBytes(nodes.size());
    }

    private static long writeNodesList(long addr, List<PeerId> nodes) {
        if (nodes == null) {
            return addr + (long)VarlenEncoder.writeLong(0L, addr);
        }
        addr += (long)VarlenEncoder.writeLong((long)nodes.size(), addr);
        for (PeerId node : nodes) {
            String nodeStr = node.getConsistentId();
            int length = nodeStr.length();
            Bits.putShortLittleEndian(addr, (short)length);
            addr += 2L;
            for (int i = 0; i < length; ++i) {
                GridUnsafe.putByte(addr + (long)i, (byte)nodeStr.charAt(i));
            }
            addr += (long)length;
            addr += (long)VarlenEncoder.writeLong((long)node.getIdx(), addr);
            addr += (long)VarlenEncoder.writeLong((long)(node.getPriority() + 1), addr);
        }
        return addr;
    }

    private static void writeNodesList(ByteBuffer content, List<PeerId> nodeStrs) {
        if (nodeStrs == null) {
            content.put((byte)0);
            return;
        }
        VarlenEncoder.writeLong((long)nodeStrs.size(), content);
        for (PeerId peerId : nodeStrs) {
            String consistentId = peerId.getConsistentId();
            int length = consistentId.length();
            content.putShort((short)length);
            AsciiStringUtil.unsafeEncode(consistentId, content);
            VarlenEncoder.writeLong((long)peerId.getIdx(), content);
            VarlenEncoder.writeLong((long)(peerId.getPriority() + 1), content);
        }
    }
}

