/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.tx.message.TransactionMetaMessage;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;
import org.apache.ignite3.internal.tx.message.TxStateResponse;
import org.apache.ignite3.internal.tx.message.TxStateResponseBuilder;

class TxStateResponseDeserializer
implements MessageDeserializer<TxStateResponse> {
    private final TxStateResponseBuilder msg;

    TxStateResponseDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txStateResponse();
    }

    @Override
    public Class<TxStateResponse> klass() {
        return TxStateResponse.class;
    }

    @Override
    public TxStateResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TxMessagesTypeInfos.txStateResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp((HybridTimestamp)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = (TransactionMetaMessage)reader.readMessage("txStateMeta");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.txStateMeta((TransactionMetaMessage)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxStateResponse.class);
    }
}

