/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.message.TxStateCommitPartitionRequest;
import org.apache.ignite3.internal.tx.message.TxStateCommitPartitionRequestBuilder;
import org.apache.ignite3.internal.tx.message.TxStateCommitPartitionRequestSerializer;

public class TxStateCommitPartitionRequestImpl
implements TxStateCommitPartitionRequest,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private final Long enlistmentConsistencyToken;
    @IgniteToStringInclude
    private final ReplicationGroupIdMessage groupId;
    @IgniteToStringInclude
    private final UUID txId;

    private TxStateCommitPartitionRequestImpl(Long enlistmentConsistencyToken, ReplicationGroupIdMessage groupId, UUID txId) {
        this.enlistmentConsistencyToken = enlistmentConsistencyToken;
        this.groupId = groupId;
        this.txId = txId;
    }

    @Override
    public Long enlistmentConsistencyToken() {
        return this.enlistmentConsistencyToken;
    }

    @Override
    public ReplicationGroupIdMessage groupId() {
        return this.groupId;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return TxStateCommitPartitionRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(TxStateCommitPartitionRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TxStateCommitPartitionRequestImpl otherMessage = (TxStateCommitPartitionRequestImpl)other;
        return Objects.equals(this.enlistmentConsistencyToken, otherMessage.enlistmentConsistencyToken) && Objects.equals(this.groupId, otherMessage.groupId) && Objects.equals(this.txId, otherMessage.txId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.enlistmentConsistencyToken, this.groupId, this.txId);
        return result;
    }

    @Override
    public TxStateCommitPartitionRequestImpl clone() {
        try {
            return (TxStateCommitPartitionRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TxStateCommitPartitionRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.groupId != null) {
            this.groupId.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements TxStateCommitPartitionRequestBuilder {
        private Long enlistmentConsistencyToken;
        private ReplicationGroupIdMessage groupId;
        private UUID txId;

        private Builder() {
        }

        @Override
        public TxStateCommitPartitionRequestBuilder enlistmentConsistencyToken(Long enlistmentConsistencyToken) {
            Objects.requireNonNull(enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable");
            this.enlistmentConsistencyToken = enlistmentConsistencyToken;
            return this;
        }

        @Override
        public TxStateCommitPartitionRequestBuilder groupId(ReplicationGroupIdMessage groupId) {
            Objects.requireNonNull(groupId, "groupId is not marked @Nullable");
            this.groupId = groupId;
            return this;
        }

        @Override
        public TxStateCommitPartitionRequestBuilder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public Long enlistmentConsistencyToken() {
            return this.enlistmentConsistencyToken;
        }

        @Override
        public ReplicationGroupIdMessage groupId() {
            return this.groupId;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public TxStateCommitPartitionRequest build() {
            return new TxStateCommitPartitionRequestImpl(Objects.requireNonNull(this.enlistmentConsistencyToken, "enlistmentConsistencyToken is not marked @Nullable"), Objects.requireNonNull(this.groupId, "groupId is not marked @Nullable"), Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }

        @Override
        public TxStateCommitPartitionRequest buildDeserialized() {
            return new TxStateCommitPartitionRequestImpl(this.enlistmentConsistencyToken, this.groupId, this.txId);
        }
    }
}

