/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import java.util.List;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.message.EnlistedPartitionGroupMessage;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;
import org.apache.ignite3.internal.tx.message.TxMetaMessage;
import org.apache.ignite3.internal.tx.message.TxMetaMessageBuilder;

class TxMetaMessageDeserializer
implements MessageDeserializer<TxMetaMessage> {
    private final TxMetaMessageBuilder msg;

    TxMetaMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txMetaMessage();
    }

    @Override
    public Class<TxMetaMessage> klass() {
        return TxMetaMessage.class;
    }

    @Override
    public TxMetaMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TxMessagesTypeInfos.txMetaMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                HybridTimestamp tmp = reader.readHybridTimestamp("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.commitTimestamp(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                HybridTimestamp tmp = reader.readList("enlistedPartitions", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.enlistedPartitions((List<EnlistedPartitionGroupMessage>)((Object)tmp));
                }
                reader.incrementState();
            }
            case 2: {
                TxState tmp;
                int shiftedId = reader.readInt("txState");
                if (!reader.isLastRead()) {
                    return false;
                }
                TxState txState = tmp = shiftedId == 0 ? null : TxState.fromId(shiftedId - 1);
                if (tmp != null) {
                    this.msg.txState(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxMetaMessage.class);
    }
}

