/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.tx.message.TxCleanupMessage;
import org.apache.ignite3.internal.tx.message.TxCleanupMessageImpl;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;

class TxCleanupMessageSerializer
implements MessageSerializer<TxCleanupMessage> {
    public static final TxCleanupMessageSerializer INSTANCE = new TxCleanupMessageSerializer();

    private TxCleanupMessageSerializer() {
    }

    @Override
    public boolean writeMessage(TxCleanupMessage msg, MessageWriter writer) throws MessageMappingException {
        TxCleanupMessageImpl message = (TxCleanupMessageImpl)msg;
        writer.setMessageTypeInfo(TxMessagesTypeInfos.txCleanupMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)5)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBoolean("commit", message.commit());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeHybridTimestamp("commitTimestamp", message.commitTimestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeList("groups", message.groups(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeUuid("txId", message.txId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

