/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.message.CleanupReplicatedInfoMessage;
import org.apache.ignite3.internal.tx.message.TxCleanupMessageErrorResponse;
import org.apache.ignite3.internal.tx.message.TxCleanupMessageErrorResponseBuilder;
import org.apache.ignite3.internal.tx.message.TxCleanupMessageErrorResponseSerializer;

public class TxCleanupMessageErrorResponseImpl
implements TxCleanupMessageErrorResponse,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 9;
    @IgniteToStringInclude
    private final CleanupReplicatedInfoMessage result;
    @IgniteToStringInclude
    private Throwable throwable;
    private byte[] throwableByteArray;
    @IgniteToStringInclude
    private final HybridTimestamp timestamp;
    @IgniteToStringInclude
    private final UUID txId;

    private TxCleanupMessageErrorResponseImpl(CleanupReplicatedInfoMessage result, Throwable throwable, byte[] throwableByteArray, HybridTimestamp timestamp, UUID txId) {
        this.result = result;
        if (throwable == null && throwableByteArray == null) {
            throw new NullPointerException("throwable is not marked @Nullable");
        }
        this.throwable = throwable;
        this.throwableByteArray = throwableByteArray;
        this.timestamp = timestamp;
        this.txId = txId;
    }

    @Override
    public CleanupReplicatedInfoMessage result() {
        return this.result;
    }

    byte[] throwableByteArray() {
        return this.throwableByteArray;
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return TxCleanupMessageErrorResponseSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(TxCleanupMessageErrorResponseImpl.class, this);
    }

    @Override
    public short messageType() {
        return 9;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TxCleanupMessageErrorResponseImpl otherMessage = (TxCleanupMessageErrorResponseImpl)other;
        return Objects.equals(this.result, otherMessage.result) && Objects.equals(this.throwable, otherMessage.throwable) && Objects.equals(this.timestamp, otherMessage.timestamp) && Objects.equals(this.txId, otherMessage.txId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.result, this.throwable, this.timestamp, this.txId);
        return result;
    }

    @Override
    public TxCleanupMessageErrorResponseImpl clone() {
        try {
            return (TxCleanupMessageErrorResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static TxCleanupMessageErrorResponseBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.result != null) {
            this.result.prepareMarshal(usedDescriptors, marshaller);
        }
        MarshalledObject throwableByteArraymo = marshaller.marshal(this.throwable);
        usedDescriptors.addAll((IntCollection)throwableByteArraymo.usedDescriptorIds());
        this.throwableByteArray = throwableByteArraymo.bytes();
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.result != null) {
            this.result.unmarshal(marshaller, descriptorsObj);
        }
        this.throwable = (Throwable)marshaller.unmarshal(this.throwableByteArray, descriptorsObj);
        this.throwableByteArray = null;
    }

    private static class Builder
    implements TxCleanupMessageErrorResponseBuilder {
        private CleanupReplicatedInfoMessage result;
        private Throwable throwable;
        private byte[] throwableByteArray;
        private HybridTimestamp timestamp;
        private UUID txId;

        private Builder() {
        }

        @Override
        public TxCleanupMessageErrorResponseBuilder result(CleanupReplicatedInfoMessage result) {
            this.result = result;
            return this;
        }

        @Override
        public TxCleanupMessageErrorResponseBuilder throwable(Throwable throwable) {
            Objects.requireNonNull(throwable, "throwable is not marked @Nullable");
            this.throwable = throwable;
            return this;
        }

        @Override
        public TxCleanupMessageErrorResponseBuilder throwableByteArray(byte[] throwableByteArray) {
            this.throwableByteArray = throwableByteArray;
            return this;
        }

        @Override
        public TxCleanupMessageErrorResponseBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public TxCleanupMessageErrorResponseBuilder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public CleanupReplicatedInfoMessage result() {
            return this.result;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public byte[] throwableByteArray() {
            return this.throwableByteArray;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public TxCleanupMessageErrorResponse build() {
            return new TxCleanupMessageErrorResponseImpl(this.result, this.throwable, this.throwableByteArray, this.timestamp, Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }

        @Override
        public TxCleanupMessageErrorResponse buildDeserialized() {
            return new TxCleanupMessageErrorResponseImpl(this.result, this.throwable, this.throwableByteArray, this.timestamp, this.txId);
        }
    }
}

