/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.tx.message.PartitionEnlistmentMessage;
import org.apache.ignite3.internal.tx.message.PartitionEnlistmentMessageImpl;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;

class PartitionEnlistmentMessageSerializer
implements MessageSerializer<PartitionEnlistmentMessage> {
    public static final PartitionEnlistmentMessageSerializer INSTANCE = new PartitionEnlistmentMessageSerializer();

    private PartitionEnlistmentMessageSerializer() {
    }

    @Override
    public boolean writeMessage(PartitionEnlistmentMessage msg, MessageWriter writer) throws MessageMappingException {
        PartitionEnlistmentMessageImpl message = (PartitionEnlistmentMessageImpl)msg;
        writer.setMessageTypeInfo(TxMessagesTypeInfos.partitionEnlistmentMessage());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeString("primaryConsistentId", message.primaryConsistentId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeSet("tableIds", message.tableIds(), MessageCollectionItemType.INT);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

