/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import java.util.Collection;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.tx.message.FinishedTransactionsBatchMessage;
import org.apache.ignite3.internal.tx.message.FinishedTransactionsBatchMessageBuilder;
import org.apache.ignite3.internal.tx.message.TxMessagesFactory;
import org.apache.ignite3.internal.tx.message.TxMessagesTypeInfos;

class FinishedTransactionsBatchMessageDeserializer
implements MessageDeserializer<FinishedTransactionsBatchMessage> {
    private final FinishedTransactionsBatchMessageBuilder msg;

    FinishedTransactionsBatchMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.finishedTransactionsBatchMessage();
    }

    @Override
    public Class<FinishedTransactionsBatchMessage> klass() {
        return FinishedTransactionsBatchMessage.class;
    }

    @Override
    public FinishedTransactionsBatchMessage getMessage() {
        return this.msg.buildDeserialized();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(TxMessagesTypeInfos.finishedTransactionsBatchMessage());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                HybridTimestamp tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.timestamp(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                HybridTimestamp tmp = reader.readCollection("transactions", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.transactions((Collection<UUID>)((Object)tmp));
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FinishedTransactionsBatchMessage.class);
    }
}

