/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.message;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.replicator.message.ZonePartitionIdMessage;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;
import org.apache.ignite3.internal.tx.message.CleanupReplicatedInfoMessage;
import org.apache.ignite3.internal.tx.message.CleanupReplicatedInfoMessageBuilder;
import org.apache.ignite3.internal.tx.message.CleanupReplicatedInfoMessageSerializer;

public class CleanupReplicatedInfoMessageImpl
implements CleanupReplicatedInfoMessage,
Cloneable {
    public static final short GROUP_TYPE = 5;
    public static final short TYPE = 18;
    @IgniteToStringInclude
    private final List<ZonePartitionIdMessage> partitions;
    @IgniteToStringInclude
    private final UUID txId;

    private CleanupReplicatedInfoMessageImpl(List<ZonePartitionIdMessage> partitions, UUID txId) {
        this.partitions = partitions;
        this.txId = txId;
    }

    @Override
    public List<ZonePartitionIdMessage> partitions() {
        return this.partitions;
    }

    @Override
    public UUID txId() {
        return this.txId;
    }

    public MessageSerializer serializer() {
        return CleanupReplicatedInfoMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 5;
    }

    public String toString() {
        return S.toString(CleanupReplicatedInfoMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 18;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CleanupReplicatedInfoMessageImpl otherMessage = (CleanupReplicatedInfoMessageImpl)other;
        return Objects.equals(this.partitions, otherMessage.partitions) && Objects.equals(this.txId, otherMessage.txId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.partitions, this.txId);
        return result;
    }

    @Override
    public CleanupReplicatedInfoMessageImpl clone() {
        try {
            return (CleanupReplicatedInfoMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static CleanupReplicatedInfoMessageBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.partitions != null) {
            for (ZonePartitionIdMessage obj : this.partitions) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.partitions != null) {
            for (ZonePartitionIdMessage obj : this.partitions) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements CleanupReplicatedInfoMessageBuilder {
        private List<ZonePartitionIdMessage> partitions;
        private UUID txId;

        private Builder() {
        }

        @Override
        public CleanupReplicatedInfoMessageBuilder partitions(List<ZonePartitionIdMessage> partitions) {
            Objects.requireNonNull(partitions, "partitions is not marked @Nullable");
            this.partitions = partitions;
            return this;
        }

        @Override
        public CleanupReplicatedInfoMessageBuilder txId(UUID txId) {
            Objects.requireNonNull(txId, "txId is not marked @Nullable");
            this.txId = txId;
            return this;
        }

        @Override
        public List<ZonePartitionIdMessage> partitions() {
            return this.partitions;
        }

        @Override
        public UUID txId() {
            return this.txId;
        }

        @Override
        public CleanupReplicatedInfoMessage build() {
            return new CleanupReplicatedInfoMessageImpl(Objects.requireNonNull(this.partitions, "partitions is not marked @Nullable"), Objects.requireNonNull(this.txId, "txId is not marked @Nullable"));
        }

        @Override
        public CleanupReplicatedInfoMessage buildDeserialized() {
            return new CleanupReplicatedInfoMessageImpl(this.partitions, this.txId);
        }
    }
}

