/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.cache.CacheStore;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.tx.TransactionException;
import org.gridgain.lang.GridgainErrorGroups;
import org.jetbrains.annotations.Nullable;

public class ReadOnlyImplicitTransactionImpl
implements InternalTransaction {
    private static final UUID FAKE_ID = new UUID(0L, 0L);
    private final HybridTimestampTracker observableTsTracker;
    private final HybridTimestamp createTs;

    ReadOnlyImplicitTransactionImpl(HybridTimestampTracker observableTsTracker, HybridTimestamp createTs) {
        this.observableTsTracker = observableTsTracker;
        this.createTs = createTs;
    }

    @Override
    public UUID id() {
        return FAKE_ID;
    }

    @Override
    public TxState state() {
        return null;
    }

    @Override
    public UUID coordinatorId() {
        return null;
    }

    @Override
    public boolean implicit() {
        return true;
    }

    @Override
    public boolean remote() {
        return false;
    }

    @Override
    public long getTimeout() {
        return 0L;
    }

    @Override
    public boolean isRolledBackWithTimeoutExceeded() {
        return false;
    }

    @Override
    public void processDelayedAck(Object val, @Nullable Throwable err) {
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public HybridTimestamp readTimestamp() {
        return null;
    }

    @Override
    public HybridTimestamp schemaTimestamp() {
        return this.createTs;
    }

    @Override
    public void enlist(ZonePartitionId replicationGroupId, int tableId, String primaryNodeConsistentId, long consistencyToken) {
    }

    @Override
    public PendingTxPartitionEnlistment enlistedPartition(ZonePartitionId replicationGroupId) {
        return null;
    }

    @Override
    public boolean assignCommitPartition(ZonePartitionId commitPartitionId) {
        return true;
    }

    @Override
    public ZonePartitionId commitPartition() {
        return null;
    }

    @Override
    public CompletableFuture<Void> commitAsync() {
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> rollbackAsync() {
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> rollbackTimeoutExceededAsync() {
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public CompletableFuture<Void> finish(boolean commitIntent, HybridTimestamp executionTimestamp, boolean full, boolean timeoutExceeded) {
        this.observableTsTracker.update(executionTimestamp);
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public boolean isFinishingOrFinished() {
        return false;
    }

    @Override
    public CompletableFuture<Void> kill() {
        return CompletableFutures.nullCompletedFuture();
    }

    @Override
    public void commit() throws TransactionException {
    }

    @Override
    public void rollback() throws TransactionException {
    }

    @Override
    public <K, V> Map<K, Optional<V>> enlistStore(CacheStore<?, ?> store) {
        throw new TransactionException(GridgainErrorGroups.Cache.TX_INCOMPATIBLE_OPERATION_ERR, IgniteStringFormatter.format("Requested operation is incompatible with cache or table type [txId={}, cache={}]", this.id(), true));
    }

    @Override
    public boolean external() {
        return false;
    }

    @Override
    public void external(boolean external) {
        throw new UnsupportedOperationException();
    }
}

