/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.ignite3.cache.CacheStore;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.apache.ignite3.internal.tx.InternalTransaction;
import org.apache.ignite3.internal.tx.PendingTxPartitionEnlistment;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.tx.Transaction;
import org.apache.ignite3.tx.TransactionException;
import org.jetbrains.annotations.Nullable;

public class PublicApiThreadingTransaction
implements InternalTransaction,
Wrapper {
    private final InternalTransaction transaction;
    private final Executor asyncContinuationExecutor;

    PublicApiThreadingTransaction(Transaction transaction, Executor asyncContinuationExecutor) {
        this.transaction = (InternalTransaction)transaction;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Override
    public void commit() throws TransactionException {
        PublicApiThreading.execUserSyncOperation(this.transaction::commit);
    }

    @Override
    public CompletableFuture<Void> commitAsync() {
        return this.preventThreadHijack(this.transaction::commitAsync);
    }

    @Override
    public void rollback() throws TransactionException {
        PublicApiThreading.execUserSyncOperation(this.transaction::rollback);
    }

    @Override
    public CompletableFuture<Void> rollbackAsync() {
        return this.preventThreadHijack(this.transaction::rollbackAsync);
    }

    @Override
    public boolean isReadOnly() {
        return this.transaction.isReadOnly();
    }

    private <T> CompletableFuture<T> preventThreadHijack(Supplier<CompletableFuture<T>> operation) {
        CompletableFuture<T> future = PublicApiThreading.execUserAsyncOperation(operation);
        return PublicApiThreading.preventThreadHijack(future, this.asyncContinuationExecutor);
    }

    @Override
    public UUID id() {
        return this.transaction.id();
    }

    @Override
    public PendingTxPartitionEnlistment enlistedPartition(ZonePartitionId replicationGroupId) {
        return this.transaction.enlistedPartition(replicationGroupId);
    }

    @Override
    public TxState state() {
        return this.transaction.state();
    }

    @Override
    public boolean assignCommitPartition(ZonePartitionId commitPartitionId) {
        return this.transaction.assignCommitPartition(commitPartitionId);
    }

    @Override
    public ZonePartitionId commitPartition() {
        return this.transaction.commitPartition();
    }

    @Override
    public void enlist(ZonePartitionId replicationGroupId, int tableId, String primaryNodeConsistentId, long consistencyToken) {
        this.transaction.enlist(replicationGroupId, tableId, primaryNodeConsistentId, consistencyToken);
    }

    @Override
    @Nullable
    public HybridTimestamp readTimestamp() {
        return this.transaction.readTimestamp();
    }

    @Override
    public HybridTimestamp schemaTimestamp() {
        return this.transaction.schemaTimestamp();
    }

    @Override
    public UUID coordinatorId() {
        return this.transaction.coordinatorId();
    }

    @Override
    public boolean implicit() {
        return this.transaction.implicit();
    }

    @Override
    public CompletableFuture<Void> finish(boolean commit, HybridTimestamp executionTimestamp, boolean full, boolean timeoutExceeded) {
        return this.transaction.finish(commit, executionTimestamp, full, timeoutExceeded);
    }

    @Override
    public boolean external() {
        return this.transaction.external();
    }

    @Override
    public void external(boolean external) {
        this.transaction.external(external);
    }

    @Override
    public <K, V> Map<K, Optional<V>> enlistStore(CacheStore<?, ?> store) {
        return this.transaction.enlistStore(store);
    }

    @Override
    public boolean isFinishingOrFinished() {
        return this.transaction.isFinishingOrFinished();
    }

    @Override
    public long getTimeout() {
        return this.transaction.getTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.transaction);
    }

    @Override
    public CompletableFuture<Void> kill() {
        return this.transaction.kill();
    }

    @Override
    public CompletableFuture<Void> rollbackTimeoutExceededAsync() {
        return this.transaction.rollbackTimeoutExceededAsync();
    }

    @Override
    public boolean isRolledBackWithTimeoutExceeded() {
        return this.transaction.isRolledBackWithTimeoutExceeded();
    }
}

