/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.policy;

import java.util.Set;
import java.util.function.Predicate;
import org.apache.ignite3.internal.schema.Column;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.row.Row;
import org.apache.ignite3.internal.table.policy.RlsContext;

class RlsPolicy {
    private final Predicate<String> roleMatcher;
    private final String columnName;

    RlsPolicy(Predicate<String> roleMatcher, String columnName) {
        this.roleMatcher = roleMatcher;
        this.columnName = columnName;
    }

    Result check(RlsContext opContext, Row row) {
        if (!this.policyApplies(opContext.roles())) {
            return Result.NOT_APPLICABLE;
        }
        SchemaDescriptor descriptor = row.schema();
        assert (descriptor != null);
        Column column = descriptor.column(this.columnName);
        assert (column != null) : "Didn't find column by name [columnName='" + this.columnName + "', schemaVersion=" + descriptor.version() + "]";
        return opContext.userName().equals(row.stringValue(column.positionInRow())) ? Result.ACCESS_ALLOWED : Result.ACCESS_FORBIDDEN;
    }

    private boolean policyApplies(Set<String> roles) {
        for (String role : roles) {
            if (!this.roleMatcher.test(role)) continue;
            return true;
        }
        return false;
    }

    static enum Result {
        NOT_APPLICABLE,
        ACCESS_ALLOWED,
        ACCESS_FORBIDDEN;

    }
}

