/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.partition;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.apache.ignite3.network.ClusterNode;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.partition.Partition;
import org.apache.ignite3.table.partition.PartitionDistribution;
import org.apache.ignite3.table.partition.PartitionManager;

public class PublicApiThreadingPartitionManager
implements PartitionManager {
    private final PartitionDistribution partitionDistribution;
    private final Executor asyncContinuationExecutor;

    public PublicApiThreadingPartitionManager(PartitionDistribution partitionDistribution, Executor asyncContinuationExecutor) {
        this.partitionDistribution = partitionDistribution;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Override
    public CompletableFuture<List<Partition>> partitionsAsync() {
        return this.preventThreadHijack(this.partitionDistribution.partitionsAsync());
    }

    @Override
    public List<Partition> partitions() {
        return this.partitionDistribution.partitions();
    }

    @Override
    public CompletableFuture<ClusterNode> primaryReplicaAsync(Partition partition) {
        return this.preventThreadHijack(this.partitionDistribution.primaryReplicaAsync(partition));
    }

    @Override
    public ClusterNode primaryReplica(Partition partition) {
        return this.partitionDistribution.primaryReplica(partition);
    }

    @Override
    public CompletableFuture<Map<Partition, ClusterNode>> primaryReplicasAsync() {
        return this.preventThreadHijack(this.partitionDistribution.primaryReplicasAsync());
    }

    @Override
    public CompletableFuture<List<Partition>> primaryReplicasAsync(ClusterNode node) {
        return this.preventThreadHijack(this.partitionDistribution.primaryReplicasAsync(node));
    }

    @Override
    public Map<Partition, ClusterNode> primaryReplicas() {
        return this.partitionDistribution.primaryReplicas();
    }

    @Override
    public List<Partition> primaryReplicas(ClusterNode node) {
        return this.partitionDistribution.primaryReplicas(node);
    }

    @Override
    public <K> CompletableFuture<Partition> partitionAsync(K key, Mapper<K> mapper) {
        return this.preventThreadHijack(this.partitionDistribution.partitionAsync(key, mapper));
    }

    @Override
    public CompletableFuture<Partition> partitionAsync(Tuple key) {
        return this.preventThreadHijack(this.partitionDistribution.partitionAsync(key));
    }

    @Override
    public <K> Partition partition(K key, Mapper<K> mapper) {
        return this.partitionDistribution.partition(key, mapper);
    }

    @Override
    public Partition partition(Tuple key) {
        return this.partitionDistribution.partition(key);
    }

    private <T> CompletableFuture<T> preventThreadHijack(CompletableFuture<T> originalFuture) {
        return PublicApiThreading.preventThreadHijack(originalFuture, this.asyncContinuationExecutor);
    }
}

