/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.storage;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteBiTuple;
import org.apache.ignite3.internal.partition.replicator.raft.PartitionSnapshotInfo;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionKey;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionMvStorageAccess;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionTxStateAccess;
import org.apache.ignite3.internal.raft.RaftGroupConfiguration;
import org.apache.ignite3.internal.raft.RaftGroupConfigurationConverter;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.secondarystoragebridge.UpdatesStorage;
import org.apache.ignite3.internal.storage.ReadResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.engine.MvPartitionMeta;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.tx.TxMeta;
import org.apache.ignite3.internal.util.Cursor;
import org.jetbrains.annotations.Nullable;

public class SecondaryStoragePartitionAccess
implements PartitionMvStorageAccess,
PartitionTxStateAccess {
    private final PartitionKey partitionKey;
    private final int tableId;
    private final UpdatesStorage updatesStorage;
    private final RaftGroupConfigurationConverter raftGroupConfigurationConverter = new RaftGroupConfigurationConverter();

    public SecondaryStoragePartitionAccess(PartitionKey partitionKey, int tableId, UpdatesStorage updatesStorage) {
        this.partitionKey = partitionKey;
        this.tableId = tableId;
        this.updatesStorage = updatesStorage;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    @Override
    public int partitionId() {
        return this.partitionKey.partitionId();
    }

    @Override
    public long lastAppliedIndex() {
        return this.updatesStorage.lastAppliedIndex();
    }

    @Override
    public long lastAppliedTerm() {
        return this.updatesStorage.lastAppliedTerm();
    }

    @Override
    @Nullable
    public RaftGroupConfiguration committedGroupConfiguration() {
        byte[] configurationBytes = this.updatesStorage.configuration();
        return configurationBytes == null ? null : this.raftGroupConfigurationConverter.fromBytes(configurationBytes);
    }

    @Override
    @Nullable
    public LeaseInfo leaseInfo() {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    @Override
    public CompletableFuture<Void> startRebalance() {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    @Override
    public CompletableFuture<Void> abortRebalance() {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    @Override
    public CompletableFuture<Void> finishRebalance(MvPartitionMeta partitionMeta) {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    @Override
    public void addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitTableId, int commitPartitionId, int catalogVersion, boolean isArchivation) {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    @Override
    public void addWriteCommitted(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTimestamp, int catalogVersion) {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    @Override
    public void addTxMeta(UUID txId, TxMeta txMeta) {
        throw new UnsupportedOperationException("TX state storage is missing.");
    }

    @Override
    public Cursor<IgniteBiTuple<UUID, TxMeta>> getAllTxMeta() {
        throw new UnsupportedOperationException("Outgoing snapshots are not supported.");
    }

    @Override
    @Nullable
    public RowId closestRowId(RowId lowerBound) {
        throw new UnsupportedOperationException("Outgoing snapshots are not supported.");
    }

    @Override
    public List<ReadResult> getAllRowVersions(RowId rowId) throws StorageException {
        throw new UnsupportedOperationException("Outgoing snapshots are not supported.");
    }

    @Override
    @Nullable
    public RowId getNextRowIdToBuildIndex(int indexId) {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    @Override
    public void setNextRowIdToBuildIndex(Map<Integer, RowId> nextRowIdToBuildByIndexId) {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    @Override
    public void updateLowWatermark(HybridTimestamp newLowWatermark) {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    @Override
    @Nullable
    public PartitionSnapshotInfo snapshotInfo() {
        throw new UnsupportedOperationException("Not implemented yet: GG-36237");
    }
}

