/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.raft.handlers;

import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.partition.replicator.network.command.UpdateMinimumActiveTxBeginTimeCommand;
import org.apache.ignite3.internal.partition.replicator.raft.CommandResult;
import org.apache.ignite3.internal.partition.replicator.raft.handlers.AbstractCommandHandler;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionDataStorage;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.table.distributed.raft.MinimumRequiredTimeCollectorService;
import org.jetbrains.annotations.Nullable;

public class MinimumActiveTxTimeCommandHandler
extends AbstractCommandHandler<UpdateMinimumActiveTxBeginTimeCommand> {
    private final PartitionDataStorage storage;
    private final TablePartitionId tablePartitionId;
    private final MinimumRequiredTimeCollectorService minTimeCollectorService;

    public MinimumActiveTxTimeCommandHandler(PartitionDataStorage storage, TablePartitionId tablePartitionId, MinimumRequiredTimeCollectorService minTimeCollectorService) {
        this.storage = storage;
        this.tablePartitionId = tablePartitionId;
        this.minTimeCollectorService = minTimeCollectorService;
    }

    @Override
    protected CommandResult handleInternally(UpdateMinimumActiveTxBeginTimeCommand command, long commandIndex, long commandTerm, @Nullable HybridTimestamp safeTimestamp) {
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return CommandResult.EMPTY_NOT_APPLIED_RESULT;
        }
        long timestamp = command.timestamp();
        this.storage.flush(false).whenComplete((r, t) -> {
            if (t == null) {
                this.minTimeCollectorService.recordMinActiveTxTimestamp(this.tablePartitionId, timestamp);
            }
        });
        return CommandResult.EMPTY_APPLIED_RESULT;
    }
}

