/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.disaster;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite3.internal.distributionzones.rebalance.RebalanceUtil;
import org.apache.ignite3.internal.distributionzones.rebalance.ZoneRebalanceUtil;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.MetaStorageManager;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.table.distributed.disaster.DisasterRecoveryManager;
import org.apache.ignite3.internal.table.distributed.disaster.DisasterRecoveryRequest;
import org.apache.ignite3.internal.table.distributed.disaster.DisasterRecoveryRequestType;
import org.apache.ignite3.internal.table.distributed.disaster.exceptions.DisasterRecoveryException;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.lang.ErrorGroups;

class SingleZoneResetDistributionRequest
implements DisasterRecoveryRequest {
    private final UUID operationId;
    private final int catalogVersion;
    private final int zoneId;

    SingleZoneResetDistributionRequest(UUID operationId, int catalogVersion, int zoneId) {
        this.operationId = operationId;
        this.catalogVersion = catalogVersion;
        this.zoneId = zoneId;
    }

    @Override
    public UUID operationId() {
        return this.operationId;
    }

    @Override
    public int zoneId() {
        return this.zoneId;
    }

    @Override
    public DisasterRecoveryRequestType type() {
        return DisasterRecoveryRequestType.SINGLE_NODE;
    }

    public int catalogVersion() {
        return this.catalogVersion;
    }

    @Override
    public CompletableFuture<Void> handle(DisasterRecoveryManager disasterRecoveryManager, long msRevision, HybridTimestamp msTimestamp) {
        int catalogVersion = disasterRecoveryManager.catalogManager.activeCatalogVersion(msTimestamp.longValue());
        if (this.catalogVersion != catalogVersion) {
            return CompletableFuture.failedFuture(new DisasterRecoveryException(ErrorGroups.DisasterRecovery.CLUSTER_NOT_IDLE_ERR, "Cluster is not idle, concurrent DDL update detected."));
        }
        Catalog catalog = disasterRecoveryManager.catalogManager.catalog(catalogVersion);
        CatalogZoneDescriptor zoneDescriptor = catalog.zone(this.zoneId);
        CompletableFuture<Set<String>> dataNodesFuture = disasterRecoveryManager.dzManager.dataNodes(msTimestamp, catalogVersion, this.zoneId);
        return dataNodesFuture.thenCompose(dataNodes -> {
            if (dataNodes.isEmpty()) {
                return CompletableFutures.nullCompletedFuture();
            }
            Set<String> aliveNodes = disasterRecoveryManager.dzManager.logicalTopology(msRevision).stream().map(NodeWithAttributes::nodeName).collect(Collectors.toSet());
            return SingleZoneResetDistributionRequest.updatePartitionDistributionForZone(zoneDescriptor, dataNodes, msRevision, msTimestamp, disasterRecoveryManager.metaStorageManager, catalog.time(), aliveNodes);
        });
    }

    private static CompletableFuture<Void> updatePartitionDistributionForTables(MetaStorageManager metaStorageManager, long msRevision, HybridTimestamp msTimestamp, CatalogZoneDescriptor zoneDescriptor, Set<String> dataNodes, Collection<CatalogTableDescriptor> tableDescriptors, long assignmentsTimestamp, Set<String> aliveNodes) {
        return CompletableFuture.allOf((CompletableFuture[])tableDescriptors.stream().map(tableDescriptor -> SingleZoneResetDistributionRequest.updatePartitionDistributionForTable(tableDescriptor, zoneDescriptor, dataNodes, msRevision, msTimestamp, metaStorageManager, assignmentsTimestamp, aliveNodes)).toArray(CompletableFuture[]::new));
    }

    private static CompletableFuture<Void> updatePartitionDistributionForTable(CatalogTableDescriptor tableDescriptor, CatalogZoneDescriptor zoneDescriptor, Set<String> dataNodes, long storageRevision, HybridTimestamp timestamp, MetaStorageManager metaStorageManager, long assignmentsTimestamp, Set<String> aliveNodes) {
        CompletableFuture[] futures = new CompletableFuture[zoneDescriptor.partitions()];
        for (int partId = 0; partId < zoneDescriptor.partitions(); ++partId) {
            TablePartitionId replicaGrpId = new TablePartitionId(tableDescriptor.id(), partId);
            futures[partId] = RebalanceUtil.updatePendingAssignmentsKeys(tableDescriptor, replicaGrpId, dataNodes, zoneDescriptor.partitions(), zoneDescriptor.replicas(), zoneDescriptor.consensusGroupSize(), storageRevision, timestamp, metaStorageManager, partId, Collections.emptySet(), Collections.emptyList(), assignmentsTimestamp, aliveNodes, zoneDescriptor.consistencyMode());
        }
        return CompletableFuture.allOf(futures);
    }

    private static CompletableFuture<Void> updatePartitionDistributionForZone(CatalogZoneDescriptor zoneDescriptor, Set<String> dataNodes, long storageRevision, HybridTimestamp timestamp, MetaStorageManager metaStorageManager, long assignmentsTimestamp, Set<String> aliveNodes) {
        CompletableFuture[] futures = new CompletableFuture[zoneDescriptor.partitions()];
        for (int partId = 0; partId < zoneDescriptor.partitions(); ++partId) {
            ZonePartitionId replicaGrpId = new ZonePartitionId(zoneDescriptor.id(), partId);
            futures[partId] = ZoneRebalanceUtil.updatePendingAssignmentsKeys(zoneDescriptor, replicaGrpId, dataNodes, zoneDescriptor.partitions(), zoneDescriptor.replicas(), zoneDescriptor.consensusGroupSize(), storageRevision, timestamp, metaStorageManager, partId, Collections.emptySet(), Collections.emptyList(), assignmentsTimestamp, aliveNodes, zoneDescriptor.consistencyMode());
        }
        return CompletableFuture.allOf(futures);
    }
}

