/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.catalog.Catalog;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.catalog.events.CatalogEvent;
import org.apache.ignite3.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite3.internal.catalog.events.DropSecondaryZoneEventParameters;
import org.apache.ignite3.internal.catalog.events.TableEventParameters;
import org.apache.ignite3.internal.event.EventListener;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.MetaStorageManager;
import org.apache.ignite3.internal.util.CompletableFutures;

class SecondaryStorageRebalanceTrigger {
    private final CatalogService catalogService;

    SecondaryStorageRebalanceTrigger(MetaStorageManager metaStorageManager, CatalogService catalogService) {
        this.catalogService = catalogService;
    }

    public void start() {
        this.catalogService.listen(CatalogEvent.TABLE_ALTER, new SecondaryDataStorageModificationListener());
    }

    public void stop() {
    }

    private CompletableFuture<Void> triggerRebalanceFor(CatalogTableDescriptor table, CatalogZoneDescriptor zone, long causalityToken, HybridTimestamp timestamp, int catalogVersion, long assignmentsTimestamp) {
        return CompletableFutures.nullCompletedFuture();
    }

    private class SecondaryDataStorageModificationListener
    implements EventListener<CatalogEventParameters> {
        private SecondaryDataStorageModificationListener() {
        }

        @Override
        public CompletableFuture<Boolean> notify(CatalogEventParameters parameters) {
            return this.handleEvent(parameters).thenApply(ignored -> false);
        }

        private CompletableFuture<Void> handleEvent(CatalogEventParameters event) {
            if (event instanceof DropSecondaryZoneEventParameters) {
                return this.handle((TableEventParameters)event);
            }
            return CompletableFutures.nullCompletedFuture();
        }

        private CompletableFuture<Void> handle(TableEventParameters event) {
            Catalog catalog = SecondaryStorageRebalanceTrigger.this.catalogService.catalog(event.catalogVersion());
            assert (catalog != null) : "Did not find a catalog by version " + event.catalogVersion();
            CatalogTableDescriptor table = catalog.table(event.tableId());
            assert (table != null) : "Did not find a table by ID " + event.tableId() + " and catalog version " + event.catalogVersion();
            CatalogZoneDescriptor zone = catalog.zone(table.zoneId());
            assert (zone != null) : "Did not find a zone by ID " + table.zoneId() + " and catalog version " + event.catalogVersion();
            return SecondaryStorageRebalanceTrigger.this.triggerRebalanceFor(table, zone, event.causalityToken(), table.updateTimestamp(), event.catalogVersion(), catalog.time());
        }
    }
}

