/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed;

import java.util.concurrent.Executor;
import org.apache.ignite3.internal.table.PublicApiThreadingKeyValueView;
import org.apache.ignite3.internal.table.PublicApiThreadingRecordView;
import org.apache.ignite3.internal.table.partition.PublicApiThreadingPartitionManager;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.table.KeyValueView;
import org.apache.ignite3.table.QualifiedName;
import org.apache.ignite3.table.RecordView;
import org.apache.ignite3.table.Table;
import org.apache.ignite3.table.TableViewOptions;
import org.apache.ignite3.table.Tuple;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.table.partition.PartitionDistribution;
import org.apache.ignite3.table.partition.PartitionManager;

public class PublicApiThreadingTable
implements Table,
Wrapper {
    private final Table table;
    private final Executor asyncContinuationExecutor;

    public PublicApiThreadingTable(Table table, Executor asyncContinuationExecutor) {
        this.table = table;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Override
    public QualifiedName qualifiedName() {
        return this.table.qualifiedName();
    }

    @Override
    public PartitionManager partitionManager() {
        return new PublicApiThreadingPartitionManager(this.table.partitionManager(), this.asyncContinuationExecutor);
    }

    @Override
    public PartitionDistribution partitionDistribution() {
        return this.partitionManager();
    }

    @Override
    public <R> RecordView<R> recordView(Mapper<R> recMapper) {
        return new PublicApiThreadingRecordView<R>(this.table.recordView(recMapper), this.asyncContinuationExecutor);
    }

    @Override
    public RecordView<Tuple> recordView() {
        return new PublicApiThreadingRecordView<Tuple>(this.table.recordView(), this.asyncContinuationExecutor);
    }

    @Override
    public <R> RecordView<R> recordView(Mapper<R> recMapper, TableViewOptions tableViewOptions) {
        return new PublicApiThreadingRecordView<R>(this.table.recordView(recMapper, tableViewOptions), this.asyncContinuationExecutor);
    }

    @Override
    public RecordView<Tuple> recordView(TableViewOptions tableViewOptions) {
        return new PublicApiThreadingRecordView<Tuple>(this.table.recordView(tableViewOptions), this.asyncContinuationExecutor);
    }

    @Override
    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper) {
        return new PublicApiThreadingKeyValueView<K, V>(this.table.keyValueView(keyMapper, valMapper), this.asyncContinuationExecutor);
    }

    @Override
    public KeyValueView<Tuple, Tuple> keyValueView() {
        return new PublicApiThreadingKeyValueView<Tuple, Tuple>(this.table.keyValueView(), this.asyncContinuationExecutor);
    }

    @Override
    public <K, V> KeyValueView<K, V> keyValueView(Mapper<K> keyMapper, Mapper<V> valMapper, TableViewOptions tableViewOptions) {
        return new PublicApiThreadingKeyValueView<K, V>(this.table.keyValueView(keyMapper, valMapper, tableViewOptions), this.asyncContinuationExecutor);
    }

    @Override
    public KeyValueView<Tuple, Tuple> keyValueView(TableViewOptions tableViewOptions) {
        return new PublicApiThreadingKeyValueView<Tuple, Tuple>(this.table.keyValueView(tableViewOptions), this.asyncContinuationExecutor);
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.table);
    }
}

