/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.secondary;

import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.secondary.SecondaryStorage;
import org.apache.ignite3.internal.storage.secondary.SecondaryTableStorage;
import org.apache.ignite3.internal.storage.secondary.ThreadAssertingSecondaryStorage;
import org.apache.ignite3.internal.worker.ThreadAssertions;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.jetbrains.annotations.Nullable;

public class ThreadAssertingSecondaryTableStorage
implements SecondaryTableStorage,
Wrapper {
    private final SecondaryTableStorage tableStorage;

    ThreadAssertingSecondaryTableStorage(SecondaryTableStorage tableStorage) {
        this.tableStorage = tableStorage;
    }

    @Override
    public void close() throws Exception {
        this.tableStorage.close();
    }

    @Override
    public int zoneId() {
        return this.tableStorage.zoneId();
    }

    @Override
    public SecondaryStorage getOrCreatePartition(int partitionId) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        return new ThreadAssertingSecondaryStorage(this.tableStorage.getOrCreatePartition(partitionId));
    }

    @Override
    @Nullable
    public SecondaryStorage getPartition(int partitionId) {
        SecondaryStorage partition = this.tableStorage.getPartition(partitionId);
        return partition == null ? null : new ThreadAssertingSecondaryStorage(partition);
    }

    @Override
    public void destroyPartition(int partitionId) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.tableStorage.destroyPartition(partitionId);
    }

    @Override
    public void start() throws StorageException {
        this.tableStorage.start();
    }

    @Override
    public void destroy() throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.tableStorage.destroy();
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.tableStorage);
    }
}

